

;	org	$8000-24		; Originate the snapshot in memory at $7FE8
;	db	'VZF1'			; HEADER: vzmagic       [04].  Can essentially be anything. This is the default.
;	db	'FILENAME         '     ; HEADER: filename      [17].  Includes the capture of a line feed at keyboard entry, hence 17.
;	db	$F1			; HEADER: Filetype      [01].  $F1 = Machine Language. NOT BASIC.
;	dw	$8000			; HEADER: Start address [02].  Typical start is at $7B00 or $8000.
;									Start of program in RAM.


	org	$8000			; originate at memory location $8000.

	call	$1C9			; CLS ROM

	ld	hl, mess1
	ld	de, 28672+512-5
	ld	bc, 5
	ldir

	ld	hl, mess2
	ld	de, 28672+512-28-32-32
	ld	bc, 24
	ldir

	ld	hl, mess3
	ld	de, 28672+512-27-32
	ld	bc, 21
	ldir

	ld	hl, g1
	call	$2B75
	ld	hl, d1			; Select Line 1 to display
	ld	de, $7006+32+8		; Position 9, top row in Video ram.
	ld	bc, 3			; 3 Characters of the ribbon to dispay.
	ldir				; display the ribbon. (Move 3 chars from Line 1 to video ram)
	


b1:	ld	hl, f1			; Select Line 3 to display.
	ld	de, $7000+32+64+8
	ld	bc, 15
	ldir
	ld	hl, f1			; Select Line 3 to display.
	ld	de, $7000+64+64+8
	ld	bc, 15
	ldir
	ld	hl, f1			; Select Line 3 to display.
	ld	de, $7000+64+64+32+8
	ld	bc, 15
	ldir
	ld	hl, f1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+8
	ld	bc, 15
	ldir


	ld	hl, f1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+64+8
	ld	bc, 15
	ldir
	ld	hl, f1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+64+32+8
	ld	bc, 15
	ldir
	ld	hl, f1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+64+64+8
	ld	bc, 15
	ldir
	ld	hl, f1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+128+32+8
	ld	bc, 15
	ldir




	ld	hl, e1
	ld	de, $7000+32+32+8
	ld	bc, 15
	ldir

	ld	hl, e1
	ld	de, $7000+32+32+8+64+64+32
	ld	bc, 15
	ldir

	ld	hl, e1
	ld	de, $7000+32+8+64+64+32+64+64+64
	ld	bc, 15
	ldir


c1: 	jp	tunes			; Forever loop to show screen. The opcode HALT doesnt work very well on the VZ/Laser.


d1: db '\O',111				; Line 1 : Ribbon. 
;e1: db '+------+------+',0	; Line 2 : Top and middle and bottom of the Christmas present box.
e1: db 107,109,109,109,109,109,109,107,109,109,109,109,109,109,107,0    ; not inversed. Top and middle and bottom

;f1: db '!      !      !',0		; Line 3 : in between bits of the Christmas present box.
f1: db 97,96,96,96,96,96,96,97,96,96,96,96,96,96,97,0

g1: db $d,0

;h1: db '+======+======+',0
h1: db 107,125,125,125,125,125,125,107,125,125,125,125,125,125,107

;i1: db '1      !      !',0		; Line 3 : in between bits of the Christmas present box.
;j1: db '!      1      !',0		; Line 3 : in between bits of the Christmas present box.
;k1: db '!      !      1',0		; Line 3 : in between bits of the Christmas present box.

i1: db 113,96,96,96,96,96,96, 97,96,96,96,96,96,96, 97,0
j1: db  97,96,96,96,96,96,96,113,96,96,96,96,96,96, 97,0
k1: db  97,96,96,96,96,96,96, 97,96,96,96,96,96,96,113,0

mess1: db "BUSHY"
mess2: db "MERRY",96,"CHRISTMAS",96,"FROM",96,"THE",0
mess3: db "VZ",114,112,112,111,"LASER",96,"COMMUNITY",0



;    normal  inv
; 1	113	49
; !	97	33
; <spc>	96	32
; =	125	61
; -	109	45
; + 	107	43

block0: db 096,096,096,096,096,096
block1: db 128,128,128,128,128,128
block2: db 143,143,143,143,143,143
block3: db 159,159,159,159,159,159
block4: db 175,175,175,175,175,175
block5: db 191,191,191,191,191,191
block6: db 207,207,207,207,207,207
block7: db 223,223,223,223,223,223
block8: db 239,239,239,239,239,239
block9: db 255,255,255,255,255,255



screenrow: db 0
x: db 0
y: db 0
turn: db 0
charac: db "A"

screen1:

	ld	hl, h1
	ld	de, $7008+32+32
	ld	bc, 15
	ldir
	ret


screen2:

	ld	hl, e1
	ld	de, $7008+32+32
	ld	bc, 15
	ldir
	ret


screen3:ld	de, $7000+32+32+8+64+64+32
	ld	hl, e1
	ld	(de), a
	ld	bc, 15
	ldir
	ret

screen4:ld	de, $7000+32+32+8+64+64+32
	ld	hl, h1
	ld	(de), a
	ld	bc, 15
	ldir
	ret


screen5:ld	de, $7008+128+256
	ld	hl, e1
	ld	(de), a
	ld	bc, 15
	ldir
	ret

screen6:ld	de, $7008+128+256
	ld	hl, h1
	ld	(de), a
	ld	bc, 15
	ldir
	ret

screen7:
	ld	hl, i1			; Select Line 3 to display.
	ld	de, $7000+32+64+8
	ld	bc, 15
	ldir
	ld	hl, i1			; Select Line 3 to display.
	ld	de, $7000+64+64+8
	ld	bc, 15
	ldir
	ld	hl, i1			; Select Line 3 to display.
	ld	de, $7000+64+64+32+8
	ld	bc, 15
	ldir
	ld	hl, i1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+8
	ld	bc, 15
	ldir


	ld	hl, i1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+64+8
	ld	bc, 15
	ldir
	ld	hl, i1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+64+32+8
	ld	bc, 15
	ldir
	ld	hl, i1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+64+64+8
	ld	bc, 15
	ldir
	ld	hl, i1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+128+32+8
	ld	bc, 15
	ldir
	ret

screen8:
	ld	hl, j1			; Select Line 3 to display.
	ld	de, $7000+32+64+8
	ld	bc, 15
	ldir
	ld	hl, j1			; Select Line 3 to display.
	ld	de, $7000+64+64+8
	ld	bc, 15
	ldir
	ld	hl, j1			; Select Line 3 to display.
	ld	de, $7000+64+64+32+8
	ld	bc, 15
	ldir
	ld	hl, j1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+8
	ld	bc, 15
	ldir


	ld	hl, j1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+64+8
	ld	bc, 15
	ldir
	ld	hl, j1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+64+32+8
	ld	bc, 15
	ldir
	ld	hl, j1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+64+64+8
	ld	bc, 15
	ldir
	ld	hl, j1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+128+32+8
	ld	bc, 15
	ldir	
	ret


screen9:
	ld	hl, k1			; Select Line 3 to display.
	ld	de, $7000+32+64+8
	ld	bc, 15
	ldir
	ld	hl, k1			; Select Line 3 to display.
	ld	de, $7000+64+64+8
	ld	bc, 15
	ldir
	ld	hl, k1			; Select Line 3 to display.
	ld	de, $7000+64+64+32+8
	ld	bc, 15
	ldir
	ld	hl, k1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+8
	ld	bc, 15
	ldir


	ld	hl, k1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+64+8
	ld	bc, 15
	ldir
	ld	hl, k1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+64+32+8
	ld	bc, 15
	ldir
	ld	hl, k1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+64+64+8
	ld	bc, 15
	ldir
	ld	hl, k1			; Select Line 3 to display.
	ld	de, $7000+64+64+64+128+32+8
	ld	bc, 15
	ldir	
	ret


screen18:
	ld	hl, block1
	ld	de, $7000+32+64+9
	ld	bc, 6
	ldir
	ld	hl, block1
	ld	de, $7000+64+64+9
	ld	bc, 6
	ldir
	ld	hl, block1
	ld	de, $7000+64+64+32+9
	ld	bc, 6
	ldir
	ld	hl, block1
	ld	de, $7000+64+64+64+9
	ld	bc, 6
	ldir
	ret


screen19:
	ld	hl, block2
	ld	de, $7000+32+64+9
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+9
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+32+9
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+64+9
	ld	bc, 6
	ldir
	ret

screen10:
	ld	hl, block2
	ld	de, $7000+32+64+9
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+9
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+32+9
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+64+9
	ld	bc, 6
	ldir
	ret


screen11:
	ld	hl, block3
	ld	de, $7000+32+64+9
	ld	bc, 6
	ldir
	ld	hl, block3
	ld	de, $7000+64+64+9
	ld	bc, 6
	ldir
	ld	hl, block3
	ld	de, $7000+64+64+32+9
	ld	bc, 6
	ldir
	ld	hl, block3
	ld	de, $7000+64+64+64+9
	ld	bc, 6
	ldir
	ret


screen12:
	ld	hl, block4
	ld	de, $7000+32+64+9
	ld	bc, 6
	ldir
	ld	hl, block4
	ld	de, $7000+64+64+9
	ld	bc, 6
	ldir
	ld	hl, block4
	ld	de, $7000+64+64+32+9
	ld	bc, 6
	ldir
	ld	hl, block4
	ld	de, $7000+64+64+64+9
	ld	bc, 6
	ldir
	ret


screen13:
	ld	hl, block5
	ld	de, $7000+32+64+9
	ld	bc, 6
	ldir
	ld	hl, block5
	ld	de, $7000+64+64+9
	ld	bc, 6
	ldir
	ld	hl, block5
	ld	de, $7000+64+64+32+9
	ld	bc, 6
	ldir
	ld	hl, block5
	ld	de, $7000+64+64+64+9
	ld	bc, 6
	ldir
	ret


screen14:
	ld	hl, block6
	ld	de, $7000+32+64+9
	ld	bc, 6
	ldir
	ld	hl, block6
	ld	de, $7000+64+64+9
	ld	bc, 6
	ldir
	ld	hl, block6
	ld	de, $7000+64+64+32+9
	ld	bc, 6
	ldir
	ld	hl, block6
	ld	de, $7000+64+64+64+9
	ld	bc, 6
	ldir
	ret


screen15:
	ld	hl, block7
	ld	de, $7000+32+64+9
	ld	bc, 6
	ldir
	ld	hl, block7
	ld	de, $7000+64+64+9
	ld	bc, 6
	ldir
	ld	hl, block7
	ld	de, $7000+64+64+32+9
	ld	bc, 6
	ldir
	ld	hl, block7
	ld	de, $7000+64+64+64+9
	ld	bc, 6
	ldir
	ret


screen16:
	ld	hl, block8
	ld	de, $7000+32+64+9
	ld	bc, 6
	ldir
	ld	hl, block8
	ld	de, $7000+64+64+9
	ld	bc, 6
	ldir
	ld	hl, block8
	ld	de, $7000+64+64+32+9
	ld	bc, 6
	ldir
	ld	hl, block8
	ld	de, $7000+64+64+64+9
	ld	bc, 6
	ldir
	ret


screen17:
	ld	hl, block9
	ld	de, $7000+32+64+9
	ld	bc, 6
	ldir
	ld	hl, block9
	ld	de, $7000+64+64+9
	ld	bc, 6
	ldir
	ld	hl, block9
	ld	de, $7000+64+64+32+9
	ld	bc, 6
	ldir
	ld	hl, block9
	ld	de, $7000+64+64+64+9
	ld	bc, 6
	ldir
	ret
; ---- 

screen20:
	ld	hl, block1
	ld	de, $7000+32+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block1
	ld	de, $7000+64+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block1
	ld	de, $7000+64+64+32+9+7
	ld	bc, 6
	ldir
	ld	hl, block1
	ld	de, $7000+64+64+64+9+7
	ld	bc, 6
	ldir
	ret


screen21:
	ld	hl, block2
	ld	de, $7000+32+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+32+9+7
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+64+9+7
	ld	bc, 6
	ldir
	ret

screen22:
	ld	hl, block2
	ld	de, $7000+32+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+32+9+7
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+64+9+7
	ld	bc, 6
	ldir
	ret


screen23:
	ld	hl, block3
	ld	de, $7000+32+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block3
	ld	de, $7000+64+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block3
	ld	de, $7000+64+64+32+9+7
	ld	bc, 6
	ldir
	ld	hl, block3
	ld	de, $7000+64+64+64+9+7
	ld	bc, 6
	ldir
	ret


screen24:
	ld	hl, block4
	ld	de, $7000+32+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block4
	ld	de, $7000+64+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block4
	ld	de, $7000+64+64+32+9+7
	ld	bc, 6
	ldir
	ld	hl, block4
	ld	de, $7000+64+64+64+9+7
	ld	bc, 6
	ldir
	ret


screen25:
	ld	hl, block5
	ld	de, $7000+32+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block5
	ld	de, $7000+64+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block5
	ld	de, $7000+64+64+32+9+7
	ld	bc, 6
	ldir
	ld	hl, block5
	ld	de, $7000+64+64+64+9+7
	ld	bc, 6
	ldir
	ret


screen26:
	ld	hl, block6
	ld	de, $7000+32+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block6
	ld	de, $7000+64+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block6
	ld	de, $7000+64+64+32+9+7
	ld	bc, 6
	ldir
	ld	hl, block6
	ld	de, $7000+64+64+64+9+7
	ld	bc, 6
	ldir
	ret


screen27:
	ld	hl, block7
	ld	de, $7000+32+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block7
	ld	de, $7000+64+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block7
	ld	de, $7000+64+64+32+9+7
	ld	bc, 6
	ldir
	ld	hl, block7
	ld	de, $7000+64+64+64+9+7
	ld	bc, 6
	ldir
	ret


screen28:
	ld	hl, block8
	ld	de, $7000+32+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block8
	ld	de, $7000+64+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block8
	ld	de, $7000+64+64+32+9+7
	ld	bc, 6
	ldir
	ld	hl, block8
	ld	de, $7000+64+64+64+9+7
	ld	bc, 6
	ldir
	ret


screen29:
	ld	hl, block9
	ld	de, $7000+32+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block9
	ld	de, $7000+64+64+9+7
	ld	bc, 6
	ldir
	ld	hl, block9
	ld	de, $7000+64+64+32+9+7
	ld	bc, 6
	ldir
	ld	hl, block9
	ld	de, $7000+64+64+64+9+7
	ld	bc, 6
	ldir
	ret

; ----
; up above are top two.
; below is bottom two
; ----



screen30:
	ld	hl, block1
	ld	de, $7000+32+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block1
	ld	de, $7000+64+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block1
	ld	de, $7000+64+64+32+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block1
	ld	de, $7000+64+64+64+9+128+32
	ld	bc, 6
	ldir
	ret


screen31:
	ld	hl, block2
	ld	de, $7000+32+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+32+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+64+9+128+32
	ld	bc, 6
	ldir
	ret

screen32:
	ld	hl, block2
	ld	de, $7000+32+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+32+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+64+9+128+32
	ld	bc, 6
	ldir
	ret


screen33:
	ld	hl, block3
	ld	de, $7000+32+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block3
	ld	de, $7000+64+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block3
	ld	de, $7000+64+64+32+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block3
	ld	de, $7000+64+64+64+9+128+32
	ld	bc, 6
	ldir
	ret


screen34:
	ld	hl, block4
	ld	de, $7000+32+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block4
	ld	de, $7000+64+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block4
	ld	de, $7000+64+64+32+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block4
	ld	de, $7000+64+64+64+9+128+32
	ld	bc, 6
	ldir
	ret


screen35:
	ld	hl, block5
	ld	de, $7000+32+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block5
	ld	de, $7000+64+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block5
	ld	de, $7000+64+64+32+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block5
	ld	de, $7000+64+64+64+9+128+32
	ld	bc, 6
	ldir
	ret


screen36:
	ld	hl, block6
	ld	de, $7000+32+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block6
	ld	de, $7000+64+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block6
	ld	de, $7000+64+64+32+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block6
	ld	de, $7000+64+64+64+9+128+32
	ld	bc, 6
	ldir
	ret


screen37:
	ld	hl, block7
	ld	de, $7000+32+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block7
	ld	de, $7000+64+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block7
	ld	de, $7000+64+64+32+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block7
	ld	de, $7000+64+64+64+9+128+32
	ld	bc, 6
	ldir
	ret


screen38:
	ld	hl, block8
	ld	de, $7000+32+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block8
	ld	de, $7000+64+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block8
	ld	de, $7000+64+64+32+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block8
	ld	de, $7000+64+64+64+9+128+32
	ld	bc, 6
	ldir
	ret


screen39:
	ld	hl, block9
	ld	de, $7000+32+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block9
	ld	de, $7000+64+64+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block9
	ld	de, $7000+64+64+32+9+128+32
	ld	bc, 6
	ldir
	ld	hl, block9
	ld	de, $7000+64+64+64+9+128+32
	ld	bc, 6
	ldir
	ret
; ---- 

screen40:
	ld	hl, block1
	ld	de, $7000+32+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block1
	ld	de, $7000+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block1
	ld	de, $7000+64+64+32+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block1
	ld	de, $7000+64+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ret


screen41:
	ld	hl, block2
	ld	de, $7000+32+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+32+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ret

screen42:
	ld	hl, block2
	ld	de, $7000+32+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+32+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block2
	ld	de, $7000+64+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ret


screen43:
	ld	hl, block3
	ld	de, $7000+32+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block3
	ld	de, $7000+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block3
	ld	de, $7000+64+64+32+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block3
	ld	de, $7000+64+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ret


screen44:
	ld	hl, block4
	ld	de, $7000+32+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block4
	ld	de, $7000+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block4
	ld	de, $7000+64+64+32+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block4
	ld	de, $7000+64+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ret


screen45:
	ld	hl, block5
	ld	de, $7000+32+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block5
	ld	de, $7000+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block5
	ld	de, $7000+64+64+32+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block5
	ld	de, $7000+64+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ret


screen46:
	ld	hl, block6
	ld	de, $7000+32+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block6
	ld	de, $7000+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block6
	ld	de, $7000+64+64+32+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block6
	ld	de, $7000+64+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ret


screen47:
	ld	hl, block7
	ld	de, $7000+32+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block7
	ld	de, $7000+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block7
	ld	de, $7000+64+64+32+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block7
	ld	de, $7000+64+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ret


screen48:
	ld	hl, block8
	ld	de, $7000+32+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block8
	ld	de, $7000+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block8
	ld	de, $7000+64+64+32+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block8
	ld	de, $7000+64+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ret


screen49:
	ld	hl, block9
	ld	de, $7000+32+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block9
	ld	de, $7000+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block9
	ld	de, $7000+64+64+32+9+7+128+32
	ld	bc, 6
	ldir
	ld	hl, block9
	ld	de, $7000+64+64+64+9+7+128+32
	ld	bc, 6
	ldir
	ret

; ----



random:	ld a,r
	rrca
	rrca
	neg
rndseed equ $ + 1
	xor 0
	rrca
	ld (rndseed),a

	cp	50
	jp	nc, random

	cp 	1
	call	z, screen1
	cp 	2
	call	z, screen2
	cp 	3
	call	z, screen3
	cp 	4
	call	z, screen4


	cp 	5
	call	z, screen5
	cp 	6
	call	z, screen6
	cp 	7
	call	z, screen7
	cp 	8
	call	z, screen8
	cp 	9
	call	z, screen9

	cp	10		; block
	call	z, screen10	; block
	cp	11		; block
	call	z, screen11	; block
	cp	12		; block
	call	z, screen12	; block
	cp	13		; block
	call	z, screen13	; block


	cp	14		; block
	call	z, screen14	; block
	cp	15		; block
	call	z, screen15	; block
	cp	16		; block
	call	z, screen16	; block
	cp	17		; block
	call	z, screen17	; block


	cp	18		; block
	call	z, screen18	; block
	cp	19		; block
	call	z, screen19	; block
	cp	20		; block
	call	z, screen20	; block
	cp	21		; block
	call	z, screen21	; block


	cp	22		; block
	call	z, screen22	; block
	cp	23		; block
	call	z, screen23	; block
	cp	24		; block
	call	z, screen24	; block
	cp	25		; block
	call	z, screen25	; block
	cp	26		; block
	call	z, screen26	; block
	cp	27		; block
	call	z, screen27	; block
	cp	28		; block
	call	z, screen28	; block
	cp	29	   	; block
	call	z, screen29	; block


	cp	30		; block
	call	z, screen30	; block
	cp	31		; block
	call	z, screen31	; block
	cp	32		; block
	call	z, screen32	; block
	cp	33		; block
	call	z, screen33	; block
	cp	34		; block
	call	z, screen34	; block
	cp	35		; block
	call	z, screen35	; block
	cp	36		; block
	call	z, screen36	; block
	cp	37	   	; block
	call	z, screen37	; block
	cp	38	   	; block
	call	z, screen38	; block
	cp	39	   	; block
	call	z, screen39	; block
	cp	40	   	; block
	call	z, screen40	; block
	cp	41	   	; block
	call	z, screen41	; block

	cp	42		; block
	call	z, screen42	; block
	cp	43		; block
	call	z, screen43	; block
	cp	44		; block
	call	z, screen44	; block
	cp	45		; block
	call	z, screen45	; block
	cp	46		; block
	call	z, screen46	; block
	cp	47		; block
	call	z, screen47	; block
	cp	48		; block
	call	z, screen48	; block
	cp	49	   	; block
	call	z, screen49	; block
	ret

;
;        \O/
;+--------+--------+
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;+--------+--------+
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;+--------+--------+
;



tunes:	
	di

	ld	a, 1
	ld	(screenrow), a
	ld hl,music_data
	call play
	ret


play
	ld e,(hl)
	inc hl
	ld d,(hl)
	ld (playRowch0ptr),de
	inc hl
	ld e,(hl)
	inc hl
	ld d,(hl)
	ld (playRowch0loop),de
	inc hl
	ld e,(hl)
	inc hl
	ld d,(hl)
	ld (playRowch1ptr),de
	inc hl
	ld e,(hl)
	inc hl
	ld d,(hl)
	ld (playRowch1loop),de
	inc hl
	ld a,(hl)
	ld (playRowspeed),a

	xor a

	di

;	in a,($1f)
;	or a
;	jr z,$+4
;	ld a,$ff
;	cpl
	
playSong



	call playRow




	jr playSong

playRow
	di

	call	random

	ld ix,$2020		;enable both tone channels (it is mask to xor with output)
	ld d,0
playRowch0ptr equ $+1
	ld hl,0			;read byte from first channel pointer
	ld c,(hl)
	ld a,c
	cp $ff
	jr nz,playRownoLoop

playRowch0loop equ $+1
	ld hl,0
	ld (playRowch0ptr),hl
playRowch1loop equ $+1
	ld hl,0
	ld (playRowch1ptr),hl
	jr playRow

playRownoLoop
	and	$3f
	jr nz,playRownoMute0	;if it is zero, mute the channel
	ld ixl,d
playRownoMute0
	inc	hl			;increase pointer
	ld (playRowch0ptr),hl	;store pointer
	ld e,a			;read divider from note table
	ld hl,noteDivTable
	add hl,de
	ld a,(hl)
	ld (playRowch0div),a	;set divider
playRowch1ptr equ $+1
	ld hl,0			;the same for second channel
	ld b,(hl)
	ld a,b
	and	$3f
	jr nz,playRownoMute1
	ld ixh,d
playRownoMute1
	inc	hl
	ld (playRowch1ptr),hl
	ld e,a
	ld hl,noteDivTable
	add	hl,de
	ld a,(hl)
	ld (playRowch1div),a
	ld a,b			;now use note values to get drum number, four bits, lower always 0
	rlca			;two top bits of note of second channel are top bits of the number
	rlca
	rl c			;and two top bits of note of first channel are lower bits
	rla
	add a,a
	and	$0f			;now there is drum number in A
	ld e,a
	ld hl,drumTable	;read drum parameters pointer from drum table
	add	hl,de
	ld a,(hl)
	inc	hl
	ld h,(hl)
	ld l,a
	ld (playRowdrumPtr),hl
	ld a,$10
	ld (playRowdrumParam0),a
	ld a,$29
	ld (playRowdrumParam1),a
	ld l,a
	xor	a
;	exa
	ex	af, af'	
	xor	a
	ld h,$10
	ld de,$0101
	exx
	ld b,a
playRowdrumPtr equ $+1
	ld hl,0
	ld e,$01
	exx
playRowspeed equ $+1
	ld c,7
playRowloop0
	ld b,0
playRowloop1
	ex	af, af'
	dec	l
	jr nz,$+3
	xor	a
	ld	($6800), a
	dec	d
	jr nz,playRowdelay0
playRowch0div equ $+1
	ld d,0
	xor ixl
playRowdrumParam0 equ $+1
	ld l,0
playRowdelay0ret:
	exx
	ld c,a
	ld a,b
	ld	($6800), a
	dec	e
	jr nz,playRowdelay1
	ld a,(hl)
	or a
	jp z,playRowdelay2
	ld e,a
	ld a,b
	xor	33	; $10
	inc	hl
playRowdelay2ret:
	ld b,a
	ld a,c
	exx
;	exa
	ex	af, af'

	dec	h
	jr nz,$+3
	xor	a
;	out	($fe),a
	ld	($6800), a
	dec	e

	jr nz,playRowdelay3
playRowch1div equ $+1
	ld e,$9d

	xor ixh
playRowdrumParam1 equ $+1
	ld	h,$17
playRowdelay3ret
	djnz playRowloop1
	push af
	ld a,(playRowdrumParam0)
	dec	a
	ld (playRowdrumParam0),a
	ld a,(playRowdrumParam1)
	sub	3
	ld (playRowdrumParam1),a
	pop	af
	dec	c
	jp nz,playRowloop0

	ld hl,$2758
	exx
	ei
	ret

playRowdelay0
	xor	0
	jp	playRowdelay0ret

playRowdelay1
	ld (0),hl
playRowdelay2
	ld r,a
	jr playRowdelay2ret

playRowdelay3
	xor	0
	jp playRowdelay3ret

drumTable
	dw drum0
	dw drum1
	dw drum2
	dw drum3
	dw drum4
	dw drum5
	dw drum6
	dw drum7

drum0
	db $00
drum1
	db $05,$05,$0e,$0e,$17,$17,$2a,$17
	db $2a,$17,$2a,$17,$2a,$17,$17,$0e
	db $0e,$04,$04,$00
drum2
	db $11,$08,$18,$06,$20,$09,$25,$0c
	db $2a,$0a,$2e,$08,$32,$0a,$37,$0d
	db $3d,$0b,$42,$09,$4c,$0b,$52,$0e
	db $5a,$0c,$62,$0a,$69,$0c,$70,$0e
	db $7b,$10,$89,$11,$96,$13,$9c,$15
	db $70,$12,$12,$72,$72,$0c,$55,$0c
	db $7a,$0b,$6d,$0b,$71,$0a,$74,$0a
	db $77,$09,$7c,$06
drum3
	db $05,$0a,$0f,$14,$1b,$20,$1b,$1e
	db $10,$14,$17,$1a,$1d,$20,$2a,$36
	db $42,$4f,$5c,$4f
drum4
	db $47,$41,$0f,$0f,$09,$0c,$01,$0d
	db $03,$05,$0e,$0c,$09,$06,$09,$0a
	db $0e,$0f,$01,$0c,$04,$0e,$08,$09
	db $06,$0b,$02,$02,$05,$06,$0c,$0b
	db $00
drum5
	db $0b,$06,$0d,$0a,$0f,$0e,$11,$12
	db $13,$16,$15,$1a,$17,$1e,$19,$22
	db $1b,$26,$1d,$00
drum6
	db $11,$05,$17,$05,$20,$05,$23,$05
	db $2a,$05,$2d,$05,$30,$05,$34,$05
	db $3f,$05,$42,$05,$4c,$05,$52,$05
	db $5f,$05,$65,$05,$69,$05,$6e,$05
	db $7b,$05,$7f,$05,$84,$05,$9f,$05
	db $65,$0f,$67,$19,$69,$23,$6b,$2d
	db $6d,$37,$6f,$41,$71,$4b,$73,$55
	db $75,$5f,$77
drum7
	db $00

noteDivTable
	db $00	;no div for mute, shifts all the notes one semitone down compared to the original
	db $fa,$eb,$de,$d2,$c6,$bb,$b0,$a6
	db $9d,$94,$8c,$84,$7c,$75,$6f,$69
	db $63,$5d,$58,$53,$4e,$4a,$46,$42
	db $3e,$3b,$37,$34,$31,$2e,$2c,$29
	db $27,$25,$23,$21,$1f,$1d,$1c,$1a
	db $19,$17,$16,$15,$14,$12

;compiled music data

music_data
	dw .ptr1,.loop1a
	dw .ptr2,.loop2a
	db $06
.ptr1
	db $2b
	db $00
	db $2b
	db $00
	db $2b
	db $00
	db $00
	db $00
	db $2b
	db $00
	db $2b
	db $00
	db $2b
	db $00
	db $00
	db $00
	db $2b
	db $00
	db $2e
	db $00
	db $27
	db $00
	db $29
	db $00
	db $2b
	db $00
	db $00
	db $00
	db $80
	db $80
	db $80
	db $00
	db $ac
	db $00
	db $2c
	db $00
	db $ac
	db $00
	db $2c
	db $00
	db $ac
	db $00
	db $2b
	db $00
	db $ab
	db $00
	db $2b
	db $2b
	db $ab
	db $00
	db $29
	db $00
	db $a9
	db $00
	db $2b
	db $00
	db $a9
	db $00
	db $00
	db $00
	db $ae
	db $00
	db $00
	db $00
	db $ab
	db $00
	db $2b
	db $00
	db $ab
	db $00
	db $00
	db $00
	db $ab
	db $00
	db $2b
	db $00
	db $ab
	db $00
	db $00
	db $00
	db $ab
	db $00
	db $2e
	db $00
	db $a7
	db $00
	db $29
	db $00
	db $ab
	db $00
	db $80
	db $80
	db $80
	db $00
	db $80
	db $80
	db $ac
	db $00
	db $ac
	db $00
	db $ac
	db $00
	db $ac
	db $00
	db $ac
	db $00
	db $ab
	db $00
	db $ab
	db $00
	db $ab
	db $2b
	db $ae
	db $00
	db $ae
	db $00
	db $ac
	db $00
	db $a9
	db $00
	db $a7
	db $00
	db $80
	db $80
	db $80
.loop1a
	db $ff
.ptr2
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $80
	db $00
	db $00
	db $00
	db $00
.loop2a
	db $ff
                                             
                                                                                      


                                                            
                                                                                        